@php
use App\Models\Utility;

$settings = Utility::settings();
$logo=\App\Models\Utility::get_file('uploads/logo');

$company_logo=Utility::getValByName('company_logo_dark');
$company_logos=Utility::getValByName('company_logo_light');

$setting = \App\Models\Utility::colorset();
$color = (!empty($setting['color'])) ? $setting['color'] : 'theme-3';
$mode_setting = \App\Models\Utility::mode_layout();
$SITE_RTL = Utility::getValByName('SITE_RTL');

$getseo= App\Models\Utility::getSeoSetting();
$metatitle = isset($getseo['meta_title']) ? $getseo['meta_title'] :'';
$metsdesc= isset($getseo['meta_desc'])?$getseo['meta_desc']:'';
$meta_image = \App\Models\Utility::get_file('uploads/meta/');
$meta_logo = isset($getseo['meta_image'])?$getseo['meta_image']:'';
$get_cookie = Utility::getCookieSetting();


@endphp
<!DOCTYPE html>
<html lang="en" dir="{{$setting['SITE_RTL'] == 'on'?'rtl':''}}">

<head>

    <title>{{__('AlphaERP')}}</title>
    <meta name="title" content="{{$metatitle}}">
    <meta name="description" content="{{$metsdesc}}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ env('APP_URL') }}">
    <meta property="og:title" content="{{$metatitle}}">
    <meta property="og:description" content="{{$metsdesc}}">
    <meta property="og:image" content="{{$meta_image.$meta_logo}}">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{ env('APP_URL') }}">
    <meta property="twitter:title" content="{{$metatitle}}">
    <meta property="twitter:description" content="{{$metsdesc}}">
    <meta property="twitter:image" content="{{$meta_image.$meta_logo}}">


    <!-- HTML5 Shim and Respond.js IE11 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 11]>
    <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->
    <!-- Meta -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="description" content="Dashboard Template Description" />
    <meta name="keywords" content="Dashboard Template" />
    <meta name="author" content="Rajodiya Infotech" />

    <!-- Favicon icon -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" integrity="sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-Fy6S3B9q64WdZWQUiU+q4/2Lc9npb8tCaSX9FK7E8HnRr0Jz8D6OP9dO5Vg3Q9ct" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js" integrity="sha384-9/reFTGAW83EW2RDu2S0VKaIzap3H66lZH81PoYlFhbGU+6BZp6G7niu735Sk7lN" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js" integrity="sha384-+sLIOodYLS7CIrQpBjl+C7nPvqq+FbNUBDunl/OZv93DB7Ln/533i8e/mZXLi/P+" crossorigin="anonymous"></script>
    <script src="https://kit.fontawesome.com/021c70449c.js" crossorigin="anonymous"></script>

    <link rel="icon" href="{{asset('assets/images/favicon.png')}}" type="image/x-icon" />

    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png') }}" />
    <link rel="stylesheet" href="{{asset('assets/landing/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{asset('assets/landing/css/font-awesome.min.css') }}" />
    <link rel="stylesheet" href="{{asset('assets/landing/css/flaticon.css') }}" />
    <link rel="stylesheet" href="{{asset('assets/landing/css/owl.carousel.min.css') }}" />
    <link rel="stylesheet" href="{{asset('assets/landing/css/owl.theme.css') }}" />
    <link rel="stylesheet" href="{{asset('assets/landing/css/lightgallery.css') }}" />
    <link rel="stylesheet" href="{{asset('assets/landing/css/woocommerce.css') }}" />

    <link rel="stylesheet" href="{{asset('assets/landing/css/style.css') }}" />
    <link rel="stylesheet" href="{{asset('assets/landing/css/home.css') }}" />
    <link rel="stylesheet" href="{{asset('assets/landing/css/royal-preload.css') }}" />

    <!-- vendor css -->
    @if ($SITE_RTL == 'on')
    <link rel="stylesheet" href="{{ asset('assets/css/style-rtl.css') }}">
    @endif

    @stack('css')
    {{-- <link rel="stylesheet" href="{{asset('assets/css/landing.css')}}" /> --}}
</head>

<body class="{{$color}} royal_preloader">

    <div id="page" class="site">
        <header id="site-header" class="site-header header-static">
            <!-- Main Header start -->
            <div class="header-desktop">
                <div class="octf-main-header is-fixed">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-logo align-self-center">
                                <div id="site-logo" class="site-logo">
                                    <a href="{{ route('home') }}">
                                        <img id="logo" src="{{ $logo .'/logo-dark.png' }}" alt="logo" width="40%" />
                                    </a>
                                </div>
                            </div>
                            <div class="col-menu text-center mano">
                                <nav id="site-navigation" class="main-navigation">
                                    <ul class="menu">
                                        <li class="#">
                                            <a href="{{ route('home') }}">Home</a>
                                        </li>
                                        <li class="#"><a href="{{ route('about-us') }}">About Us</a></li>

                                        <li class="#"><a href="{{ route('features') }}">Features</a></li>
                                        <li class="#"><a href="{{ route('pricing') }}">Pricing Plans</a>
                                        </li>
                                        <li><a href="{{ route('contact-us') }}">Contact Us</a></li>
                                    </ul>
                                </nav>
                            </div>
                            <div class="col-cta align-self-center">
                                <div class="octf-btn-cta justify-content-end">
                                    <div class="octf-header-btn octf-cta-header">
                                        <div class="btn-cta-group btn-cta-header">
                                            <a class="octf-btn octf-btn-second" href="{{ route('login') }}">Sign In</a>
                                        </div>
                                        <div class="btn-cta-group btn-cta-header">
                                            <a class="octf-btn octf-btn-second ml-3" href="{{ route('register') }}">Sign Up</a>
                                        </div>
                                    </div>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="header_mobile">
                <div class="container-fluid">
                    <div class="octf-mainbar-row octf-row">
                        <div class="octf-col">
                            <div class="mlogo_wrapper clearfix">
                                <div class="mobile_logo">
                                    <a href="{{ route('home') }}">
                                        <img id="logo" src="{{ $logo .'/logo-dark.png' }}" alt="logo" width="40%" />
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="octf-col justify-content-end">
                            <div class="octf-search octf-cta-header align-self-center">

                                <!-- Form Search on Header -->

                            </div>
                            <div id="mmenu-toggle" class="mmenu-toggle align-self-center">
                                <button><i class="ot-flaticon-menu-of-three-lines"></i></button>
                            </div>
                            <div class="site-overlay mmenu-overlay"></div>
                        </div>
                        <div id="mmenu-wrapper" class="mmenu-wrapper on-right">
                            <div class="mmenu-inner">
                                <a class="mmenu-close" href="#"><i class="ot-flaticon-right-arrow"></i></a>
                                <div class="mobile-nav">
                                    <ul id="menu-main-menu" class="mobile_mainmenu none-style">
                                        <li class="#">
                                            <a href="{{ route('home') }}">Home</a>
                                        </li>
                                        <li class="#"><a href="{{ route('about-us') }}">About Us</a></li>

                                        <li class="#"><a href="{{ route('features') }}">Features</a></li>
                                        <li class="#"><a href="{{ route('pricing') }}">Pricing Plans</a>
                                        </li>
                                        <li><a href="{{ route('contact-us') }}">Contact Us</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        @yield('content')

        <footer id="site-footer" class="site-footer">
            <div class="container">
                <div class="space-90"></div>
                <div class="row">
                    <div class="col-lg-6 mb-5 mb-lg-0">
                        <h3 class="text-light">Ready to Get Started? <br> Sign Up Now and Try Free</h3>
                    </div>
                    <div class="col-lg-6">
                        <form action="https://templates.thememodern.com/progrisaas/newsletter.php" id="ajax-form" name="ajax-form" method="post" class="mc4wp-form">
                            <div class="mc4wp-form-fields">
                                <div class="main-form">
                                    <input id="email" type="email" name="email" placeholder="Enter Your Email" required="">
                                    <input type="submit" id="send" value="Subscribe Now">
                                    <div class="clear"></div>
                                    <div class="error" id="err-form">There was a problem validating the form please check!</div>
                                    <div class="error" id="err-timedout">The connection to the server timed out!</div>
                                    <div class="error" id="err-state"></div>

                                </div>
                            </div>
                        </form>
                        <div class="clear"></div>
                        <div id="ajaxsuccess">Successfully sent!!</div>
                        <div class="clear"></div>
                    </div>
                </div>

                <hr class="f1">

                <div class="space-5"></div>
                <div class="row">
                    <div class="col-lg-6 col-md-8 mb-3 mb-md-0 align-self-center">
                        <p class="copyright">Copyright © 2023. Designed by Nexprism. All Rights Reserved.</p>
                    </div>
                    <div class="col-lg-5 col-md-4 text-md-right">
                        <ul class="ft-menu">
                            <li><a href="#">Privacy Policy</a></li>
                            <li><a href="#">Terms of Use</a></li>
                        </ul>
                    </div>
                </div>
                <div class="space-40"></div>
            </div>
        </footer>
    </div>
    <!-- [ Nav ] start -->
    <!-- [ dashboard ] End -->
    <!-- Required Js -->
    <a id="back-to-top" href="# class=" show"><i class="ot-flaticon-up-arrow"></i></a>
    <script src="{{asset('assets/landing/js/jquery.min.js') }}"></script>
    <script src="{{asset('assets/landing/js/lightgallery-all.min.js') }}"></script>
    <script src="{{asset('assets/landing/js/jquery.isotope.min.js') }}"></script>
    <script src="{{asset('assets/landing/js/owl.carousel.min.js') }}"></script>
    <script src="{{asset('assets/landing/js/easypiechart.min.js') }}"></script>
    <script src="{{asset('assets/landing/js/jquery.countdown.min.js') }}"></script>
    <script src="{{asset('assets/landing/js/scripts.js') }}"></script>
    <script src="{{asset('assets/landing/js/contact.html') }}"></script>
    <script src="{{asset('assets/landing/js/royal_preloader.min.js') }}"></script>
    <script>
        window.jQuery = window.$ = jQuery;
        (function($) {
            "use strict ";
            //Preloader
            Royal_Preloader.config({
                mode: 'logo',
                logo: $('#logo').attr('src'),
                logo_size: [160, 75],
                showProgress: true,
                showPercentage: true,
                text_colour: '#000000',
                background: '#ffffff'
            });
        })(jQuery);
    </script>
    <script>
        // Start [ Menu hide/show on scroll ]
        let ost = 0;
        document.addEventListener("scroll", function() {
            let cOst = document.documentElement.scrollTop;
            if (cOst == 0) {
                document.querySelector(".navbar").classList.add("top-nav-collapse");
            } else if (cOst > ost) {
                document.querySelector(".navbar").classList.add("top-nav-collapse");
                document.querySelector(".navbar").classList.remove("default");
            } else {
                document.querySelector(".navbar").classList.add("default");
                document
                    .querySelector(".navbar")
                    .classList.remove("top-nav-collapse");
            }
            ost = cOst;
        });
        // End [ Menu hide/show on scroll ]
        var wow = new WOW({
            animateClass: "animate__animated", // animation css class (default is animated)
        });
        wow.init();
        var scrollSpy = new bootstrap.ScrollSpy(document.body, {
            target: "#navbar-example",
        });
    </script>
    @stack('script')
    @if($get_cookie['enable_cookie'] == 'on')
    @include('layouts.cookie_consent')
    @endif
</body>

</html>