  
 <?php $__env->startSection('page-title'); ?> 
 <?php echo e(__('Manage Leave Type')); ?> 
 <?php $__env->stopSection(); ?>
 <?php $__env->startSection('content'); ?> 
   <div id="content" class="site-content">
            <div class="page-header dtable text-center">
                <div class="dcell">
                    <div class="container">
                        <h1 class="page-title">Pricing Plans</h1>
                        <ul id="breadcrumbs" class="breadcrumbs none-style">
                            <li><a href="index.html">Home</a></li>
                            <li class="active">Pricing Plans</li>
                        </ul> 
                    </div>
                </div>
            </div>
        </div>

        <section class="pricing-sec-1">
            <div class="container">
                <div class="space-90"></div>
                <div class="row">
                    <div class="col-lg-6 offset-lg-3 text-center px-lg-0">
                        <div class="ssub-yes">
                            <div class="ot-heading">
                                <span class="ot-heading__sub">Pricing Plans v1</span>
                                <h2 class="ot-heading__title">The Right Price for You</h2>
                            </div>
                        </div>
                        <div class="space-10"></div>
                        <div class="space-5"></div>
                        <p>Get control and visibility over spending. Try any plan free for 30 days with no lock-in commitments.</p>
                        <div class="space-20"></div>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <?php if($plans): ?>
                    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                    
                    <div class="col-lg-4 col-md-6 mb-5 mb-lg-0">
                        <div class="ot-pricing-table --second-color pricing-border radius-main">
                            <div class="ot-pricing-table__header">
                                <h3 class="ot-pricing-table__title"><?php echo e($plan->name); ?></h3>
                                <span class="ot-pricing-table__subtitle"><?php echo e($plan->description); ?></span>
                            </div>
                            <div class="ot-pricing-table__price">
                                <div class="ot-pricing-table__price-main"><?php echo e((env('CURRENCY_SYMBOL') ? env('CURRENCY_SYMBOL') : '$')); ?><?php echo e(number_format($plan->price)); ?><span class="ot-pricing-table__period">/m</span></div>
                                <span class="ot-pricing-table__price-extra"><?php echo e($plan->duration); ?></span>
                            </div>
                            <div class="ot-pricing-table__features-list">
                                <ul>
                                    <li><?php echo e($plan->max_users); ?> Users </li>
                                    <li><?php echo e($plan->max_customers); ?> Customers </li>
                                    <li><?php echo e($plan->max_venders); ?> Vendors </li>
                                    <li><?php echo e($plan->max_clients); ?> Clients </li>
                                    <li> <?php echo e(($plan->storage_limit == -1)?'Unlimited' : $plan->storage_limit.'MB'); ?> Storage</li>
                                    <?php if($plan->crm == 1): ?>
                                    <li>CRM</li>
                                    <?php endif; ?>
                                    <?php if($plan->hrm == 1): ?>
                                    <li>HRM</li>
                                    <?php endif; ?>
                                    <?php if($plan->account == 1): ?>
                                    <li>Account Manager</li>
                                    <?php endif; ?>
                                    <?php if($plan->project == 1): ?>
                                    <li>Project Manager</li>
                                    <?php endif; ?>
                                    <?php if($plan->pos == 1): ?>
                                    <li>POS</li>
                                    <?php endif; ?>
                                    <?php if($plan->chatgpt == 1): ?>
                                    <li>Chat GPT</li>
                                    <?php endif; ?>
                                    
                                    
                                </ul>
                            </div>
                            <div class="space-70"></div>
                            <div class="ot-pricing-table__footer">
                                <a href="<?php echo e(route('company.register',$plan->id)); ?>" class="octf-btn octf-btn-second --price-link-trial">Subscribe Now</a>
                                
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    
                </div>
              
               
               
             
                <div class="space-100"></div>
            </div>
        </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.landing', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\new_erp\resources\views/front/pricing.blade.php ENDPATH**/ ?>